function query4DProjectMethodExecution()
{
	const projectMethod = arguments[0];
	
	var lastArgument = arguments[arguments.length - 1];
	var methodParams = null;
	var callBack = null;
	
	// Check if a callback has been passed as last argument
	if ( typeof lastArgument === "function" )
	{
		callBack = lastArgument;
		methodParams = Array.prototype.slice.call( arguments ).slice( 1, arguments.length - 1 );
	}
	else
	{
		methodParams = Array.prototype.slice.call( arguments ).slice( 1 ); // from element 1 to the end
	}

	const mustLog = this.$debug;
	if (mustLog) console.log(`call: ${projectMethod}(${methodParams})`);

	const requestObject =
	{
		method:		projectMethod,
		parameters:	methodParams
	};

	const request_id = window.JSBridge4D_query(
	{
		request: JSON.stringify( requestObject ),
		persistent: false,
		onSuccess: function( response )
		{
			if (mustLog) console.log(`onSuccess: ${projectMethod}, result = ${response}`);
			if ( callBack )
			{
				try
				{
					const parsedObject = JSON.parse( response );
					callBack( parsedObject, null );
				}
				catch ( parseException )
				{
					console.warn( "[4D JS Bridge] Warning, JSON.parse() failed: '" + parseException + "'. Will now try to eval() result." );
					
					try
					{
						const evalObject = eval( response );
						callBack( evalObject, null );
					}
					catch ( evalException )
					{
						console.warn( "[4D JS Bridge] Warning, eval() failed too: '" + evalException + "'." );
						callBack( response, null );
					}
				}
			}
		},
		onFailure: function( error_code, error_message )
		{
			if (mustLog) console.log(`onFailure: ${projectMethod} throw (${error_code}, ${error_message})`);
			if ( callBack )
				callBack( null, null );
		}
	});

	return requestObject;
}

var proxyHandler =
{
	get:function( target, name, receiver )
	{
		return function()
		{
			var arrayArguments = Array.prototype.slice.call( arguments );

			arrayArguments.unshift( name );

			return query4DProjectMethodExecution.apply( target, arrayArguments );
		};
	}
};

var $4d = new Proxy( {}, proxyHandler );
$4d.$debug=false;

function defaultBridgeCallBack( result )
{
	var logMessage;
	if ( result != undefined )
	{
		logMessage = "success, result=" + result;
	}
	else
	{
		logMessage = "failure";
	}

	alert( logMessage );
	console.log( logMessage );
}

//$4d.methodProject( "arg1", "arg2", "argN", defaultBridgeCallBack );
